/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class BattleStates {
    private static Map<UUID, State> STATES = new HashMap<UUID, State>();

    public static State get(PokemonBattle battle) {
        if (!battle.getEnded()) {
            return STATES.computeIfAbsent(battle.getBattleId(), k -> new State());
        }
        return new State();
    }

    public static void setTurn(ActiveBattlePokemon pkmn, boolean turn) {
        State bs = BattleStates.get(pkmn.getBattle());
        if (turn && pkmn.hasPokemon()) {
            bs.switchReplacements.remove(pkmn.getBattlePokemon());
        }
        bs.turnStates.put(pkmn, turn);
    }

    public static void setWillBeSwitchedInFor(BattlePokemon in, ActiveBattlePokemon out) {
        if (out.hasPokemon()) {
            BattleStates.get((PokemonBattle)out.getBattle()).switchReplacements.put(out.getBattlePokemon(), in);
            out.getBattlePokemon().setWillBeSwitchedIn(false);
        }
        in.setWillBeSwitchedIn(true);
    }

    public static void notifyPokemonFainted(PokemonBattle battle, BattlePokemon pkmn) {
        BattlePokemon replacement;
        if (STATES.containsKey(battle.getBattleId()) && (replacement = BattleStates.STATES.get((Object)battle.getBattleId()).switchReplacements.remove(pkmn)) != null) {
            replacement.setWillBeSwitchedIn(false);
        }
    }

    public static void notifyBattleEnded(PokemonBattle battle) {
        STATES.remove(battle.getBattleId());
    }

    private BattleStates() {
    }

    public static class State {
        private Map<BattlePokemon, BattlePokemon> switchReplacements = new HashMap<BattlePokemon, BattlePokemon>();
        private Map<ActiveBattlePokemon, Boolean> turnStates = new HashMap<ActiveBattlePokemon, Boolean>();

        private State() {
        }

        public boolean isTurn(ActiveBattlePokemon pkmn) {
            return this.turnStates.getOrDefault(pkmn, false);
        }
    }
}

